$(function() {
  let contactName = '';

  function appendMessage(text, isUser = false) {
    const cls = isUser ? 'user' : 'bot';
    $('#messages').append(`<div class="${cls}">${text}</div>`);
    $('#messages').scrollTop($('#messages')[0].scrollHeight);
  }

  function renderNameInput() {
    $('#choices').html(`
      <input id="nameInput" type="text" placeholder="Your name…" />
      <button id="nameSubmit">Submit 😊</button>
    `);
  }

  function loadName() {
    appendMessage(`Hi there! This is Matt's Contact Info Assistant. What can I call you? 😊`);
    renderNameInput();
  }

  function loadProfiles() {
    appendMessage(`Well hello ${contactName}! What is your reason for contacting Matt? 🤔`);
    $.getJSON('get_profiles.php', profiles => {
      renderChoices(profiles, 'profile');
    });
  }

  function loadPlatforms(profile) {
    appendMessage(`Got it, ${contactName}! You're contacting Matt for <strong>${profile}</strong> reasons. What is your preferred platform? 🤔`);
    $.getJSON('get_platforms.php', { profile }, platforms => {
      renderChoices(platforms.map(p => p.name), 'platform', platforms);
    });
  }

  function renderChoices(options, step, details = []) {
    $('#choices').empty();
    options.forEach((opt, i) => {
      const { number = '', link = '' } = details[i] || {};
      $('#choices').append(
        `<button data-step="${step}" data-value="${opt}" data-number="${number}" data-link="${link}">${opt}</button>`
      );
    });
  }

  // Name submission
  $('#choices').off('click').on('click', '#nameSubmit', function() {
    const name = $('#nameInput').val().trim();
    if (!name) return;
    appendMessage(name, true);
    contactName = name;
    $.post('save.php', { step: 'name', value: name }, () => loadProfiles(), 'json');
  });

  // Profile & platform selection
  $('#choices').on('click', 'button[data-step]', function() {
    const step   = $(this).data('step');
    const value  = $(this).data('value');
    const number = $(this).data('number');
    const link   = $(this).data('link');
    appendMessage(value, true);
    $.post('save.php', { step, value, number }, () => {
      if (step === 'profile') {
        loadPlatforms(value);
      } else if (step === 'platform') {
        appendMessage(`Great choice! <strong>${value}</strong> is a good one. Here’s the number or username to use: <strong>${number}</strong> 🎉`);
        let controls = `<button id="copyBtn" data-number="${number}">Copy to clipboard 📋</button>`;
        if (link) controls += `<button id="openBtn" data-link="${link}">Open in ${value} 🔗</button>`;
        $('#choices').html(controls);
      }
    }, 'json');
  });

  // Copy & open handlers
  $(document).on('click', '#copyBtn', function() {
    const num = $(this).data('number');
    navigator.clipboard.writeText(num)
      .then(() => appendMessage('Number copied to clipboard! 👍'))
      .catch(() => appendMessage('Failed to copy. 😕'));    
  });

  $(document).on('click', '#openBtn', function() {
    const url = $(this).data('link');
    if (url) window.open(url, '_blank');
  });

  // Start
  loadName();
});